"use client";

import { useState } from "react";

type VisibilityDebugProps = {
  showAll: boolean;
};

/**
 * Development-only debug component
 * NEVER exposes sensitive detection data (Google Ads params, mobile flags, referer, bot detection)
 * Only shows the final result (showAll boolean) for debugging purposes
 * Automatically disabled in production builds
 */
export function VisibilityDebug({ showAll }: VisibilityDebugProps) {
  // Only show in development - double check client-side
  const [isDismissed, setIsDismissed] = useState(false);
  const isDevelopment = process.env.NODE_ENV === "development";

  if (!isDevelopment || isDismissed) return null;

  return (
    <div className="fixed bottom-4 right-4 z-50 max-w-sm rounded-lg border-2 border-blue-500 bg-white p-4 shadow-xl">
      <div className="mb-2 flex items-center justify-between">
        <h3 className="text-sm font-bold text-slate-900">🔍 Visibility Debug</h3>
        <button
          onClick={() => setIsDismissed(true)}
          className="text-slate-400 hover:text-slate-600"
          aria-label="Close"
        >
          ×
        </button>
      </div>
      <div className="space-y-2 text-xs">
        <div className="mt-3 border-t border-slate-200 pt-2">
          <div className="flex items-center justify-between">
            <span className="font-bold text-slate-900">Visibility Result:</span>
            <span
              className={`font-bold ${showAll ? "text-green-600" : "text-orange-600"}`}
            >
              {showAll ? "Show ALL Partners" : "Show ONLY Licensed"}
            </span>
          </div>
        </div>
        <p className="text-xs text-slate-500 italic">
          Sensitive detection data is never exposed in HTML
        </p>
      </div>
    </div>
  );
}

