"use client";

import { useState } from "react";

export function ContactForm() {
  const [status, setStatus] = useState<"idle" | "success">("idle");

  return (
    <form
      className="space-y-6"
      onSubmit={(event) => {
        event.preventDefault();
        setStatus("success");
      }}
    >
      <div className="space-y-2">
        <label htmlFor="name" className="block text-sm font-semibold text-white/90">
          Name
        </label>
        <input
          id="name"
          name="name"
          type="text"
          required
          autoComplete="name"
          className="w-full rounded-xl border border-white/20 bg-white/10 backdrop-blur-sm px-5 py-3.5 text-sm text-white shadow-sm transition-all duration-200 placeholder:text-white/50 focus:border-white/40 focus:bg-white/15 focus:outline-none focus:ring-2 focus:ring-white/20 hover:border-white/30"
          placeholder="Jane Doe"
        />
      </div>
      <div className="space-y-2">
        <label htmlFor="email" className="block text-sm font-semibold text-white/90">
          Email
        </label>
        <input
          id="email"
          name="email"
          type="email"
          required
          autoComplete="email"
          className="w-full rounded-xl border border-white/20 bg-white/10 backdrop-blur-sm px-5 py-3.5 text-sm text-white shadow-sm transition-all duration-200 placeholder:text-white/50 focus:border-white/40 focus:bg-white/15 focus:outline-none focus:ring-2 focus:ring-white/20 hover:border-white/30"
          placeholder="you@company.com"
        />
      </div>
      <div className="space-y-2">
        <label htmlFor="message" className="block text-sm font-semibold text-white/90">
          Message
        </label>
        <textarea
          id="message"
          name="message"
          rows={5}
          required
          className="w-full resize-none rounded-xl border border-white/20 bg-white/10 backdrop-blur-sm px-5 py-3.5 text-sm text-white shadow-sm transition-all duration-200 placeholder:text-white/50 focus:border-white/40 focus:bg-white/15 focus:outline-none focus:ring-2 focus:ring-white/20 hover:border-white/30"
          placeholder="Give us a short overview of your campaign goals."
        />
      </div>
      <button
        type="submit"
        className="group/btn relative inline-flex w-full items-center justify-center gap-2 overflow-hidden rounded-xl bg-gradient-to-r from-slate-900 via-slate-800 to-slate-900 px-6 py-4 text-sm font-semibold text-white shadow-lg shadow-slate-900/20 transition-all duration-300 hover:scale-[1.02] hover:shadow-xl hover:shadow-slate-900/30 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-slate-900 active:scale-[0.98]"
      >
        <span className="relative z-10">Submit enquiry</span>
        <span className="absolute inset-0 bg-gradient-to-r from-slate-800 via-slate-700 to-slate-800 opacity-0 transition-opacity duration-300 group-hover/btn:opacity-100" />
      </button>
      {status === "success" && (
        <div className="rounded-xl border border-emerald-500/30 bg-emerald-500/10 backdrop-blur-sm p-4 shadow-sm">
          <p className="text-sm font-semibold text-emerald-100">
            Thanks for reaching out! A member of the BetRanked team will get back to you within 24 hours.
          </p>
        </div>
      )}
    </form>
  );
}
