import { NextRequest, NextResponse } from 'next/server';
import { cookies } from 'next/headers';
import { getClicks, resetClicks } from '@/lib/clicks';

async function checkAuth() {
  const cookieStore = await cookies();
  const auth = cookieStore.get('admin-auth');
  return auth?.value === 'authenticated';
}

export async function GET() {
  if (!(await checkAuth())) {
    return NextResponse.json({ error: 'Unauthorized' }, { status: 401 });
  }

  try {
    const clicks = getClicks();
    return NextResponse.json(clicks);
  } catch (error) {
    return NextResponse.json(
      { error: 'Failed to get clicks' },
      { status: 500 }
    );
  }
}

export async function POST(request: NextRequest) {
  if (!(await checkAuth())) {
    return NextResponse.json({ error: 'Unauthorized' }, { status: 401 });
  }

  try {
    const { action }: { action: string } = await request.json();
    
    if (action === 'reset') {
      resetClicks();
      return NextResponse.json({ success: true });
    }
    
    return NextResponse.json(
      { error: 'Invalid action' },
      { status: 400 }
    );
  } catch (error) {
    return NextResponse.json(
      { error: 'Failed to reset clicks' },
      { status: 500 }
    );
  }
}

