# Deployment Troubleshooting Guide

## 503 Service Unavailable Error

If you're getting a 503 error, follow these steps:

### Step 1: Check Application Status
1. In your hosting control panel, check if the application is **RUNNING**
2. If it shows "STOPPED", click **"RESTART"** button
3. Wait 30-60 seconds for the application to start

### Step 2: Verify Build
The application must be built before running. In your hosting control panel:

1. **Run NPM Install** (if not already done):
   - Click the "Run NPM Install" button
   - Wait for it to complete

2. **Build the application**:
   - SSH into your server or use terminal
   - Run: `npm run build`
   - This creates the `.next` folder required for production

### Step 3: Check Application Startup File
- **Startup file should be**: `server.js`
- Make sure it's in the root directory
- Verify the file exists in your application root

### Step 4: Check Environment Variables
In your hosting control panel, add these environment variables:

```
NODE_ENV=production
PORT=3000
HOSTNAME=0.0.0.0
```

**Note**: Your hosting provider might automatically set PORT. Check what port they assign and use that.

### Step 5: Check Application Logs
1. In your hosting control panel, look for **"Logs"** or **"Application Logs"**
2. Check for error messages that might indicate:
   - Missing dependencies
   - Port conflicts
   - Build errors
   - File permission issues

### Step 6: Verify File Structure
Make sure these files/folders exist in your application root:
```
/
├── server.js          ✅ Must exist
├── package.json       ✅ Must exist
├── next.config.mjs    ✅ Must exist
├── .next/             ✅ Must exist (created by npm run build)
├── data/              ✅ Must exist
│   ├── partners.json
│   └── siteinfo.json
├── public/            ✅ Must exist
└── src/               ✅ Must exist
```

### Step 7: Common Issues & Solutions

#### Issue: "Cannot find module 'next'"
**Solution**: Run `npm install` in your application root

#### Issue: "Port already in use"
**Solution**: 
- Check what port your hosting provider assigns
- Update PORT environment variable accordingly
- Or use the port assigned by your hosting provider

#### Issue: "Build failed"
**Solution**:
- Check Node.js version (should be 22.18.0 as shown in your panel)
- Run `npm run build` manually
- Check for TypeScript or build errors

#### Issue: "Permission denied"
**Solution**:
- Run `npm run setup` to set up upload directories
- Check file permissions on `data/` and `public/` folders

### Step 8: Manual Deployment Steps

If using SSH/terminal:

```bash
# 1. Navigate to your application directory
cd /home/betruixl/betreviews.world

# 2. Activate virtual environment (if needed)
source /home/betruixl/nodevenv/betreviews.world/22/bin/activate

# 3. Install dependencies
npm install

# 4. Build the application
npm run build

# 5. Set up directories
npm run setup

# 6. Start the application
npm start
```

### Step 9: Alternative - Use Next.js Default Server

If `server.js` continues to cause issues, you can use Next.js's built-in server:

1. Change `package.json` start script to:
```json
"start": "next start"
```

2. Make sure PORT environment variable is set correctly

### Step 10: Check Hosting Provider Requirements

Some hosting providers require:
- Specific port numbers
- Specific hostname (0.0.0.0 or localhost)
- Specific startup commands

Check your hosting provider's documentation for Node.js/Next.js requirements.

---

## Quick Checklist

- [ ] Application is RUNNING (not STOPPED)
- [ ] `npm install` has been run
- [ ] `npm run build` has been run successfully
- [ ] `.next` folder exists
- [ ] `server.js` file exists in root
- [ ] Environment variables are set (NODE_ENV=production)
- [ ] PORT matches hosting provider's assigned port
- [ ] No errors in application logs
- [ ] File permissions are correct

---

## Still Having Issues?

1. **Check application logs** for specific error messages
2. **Verify Node.js version** matches (22.18.0)
3. **Test locally** first: `npm run build && npm start`
4. **Contact hosting support** with error logs

